/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Tok;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TimeZone;

public class MyProperties {
    private ArrayList<PropItem> prop = new ArrayList();
    private HashMap<String, PropItem> hash = new HashMap();
    private StringBuilder propOriginal = null;
    static final String CR = System.getProperty("line.separator");
    static final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm";
    static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");

    public MyProperties clone() {
        MyProperties p = new MyProperties();
        for (PropItem i : this.prop) {
            p.add(i.key, i.value);
        }
        p.propOriginal = this.propOriginal == null ? null : new StringBuilder(this.propOriginal);
        return p;
    }

    public ArrayList<String> getKeys() {
        ArrayList<String> a = new ArrayList<String>();
        for (PropItem ci : this.prop) {
            a.add(ci.key);
        }
        return a;
    }

    public boolean removeComment(String s) {
        int find = -1;
        for (int i = 0; i < this.prop.size(); ++i) {
            PropItem pi = this.prop.get(i);
            if (!pi.key.equals("#") || pi.value == null || !pi.value.equals(s)) continue;
            find = i;
            break;
        }
        if (find == -1) {
            return false;
        }
        this.prop.remove(find);
        return true;
    }

    public boolean equals(MyProperties p) {
        if (this == p) {
            return true;
        }
        if (p == null) {
            return false;
        }
        if (Math.abs(this.size() - p.size()) > 1) {
            return false;
        }
        for (String k : this.getKeys()) {
            String v;
            String v1;
            if (k.equals(" ") || k.equals("#") || k.equals("TIMESTAMP") || (v1 = p.get(k)) == (v = this.get(k))) continue;
            if (v1 == null && v != null || v1 != null && v == null) {
                return false;
            }
            if (v1.indexOf(9) < 0 && v.indexOf(9) < 0) {
                if (v1.equals(v)) continue;
                return false;
            }
            if (v1.equals(v)) continue;
            int n = 0;
            int n1 = 0;
            Tok tok = new Tok(v, "\t");
            HashMap<String, String> hash = new HashMap<String, String>(100);
            while (tok.hasMoreTokens()) {
                hash.put(tok.nextToken(), "");
                ++n;
            }
            tok = new Tok(v1, "\t");
            while (tok.hasMoreTokens()) {
                if (hash.get(tok.nextToken()) == null) {
                    return false;
                }
                ++n1;
            }
            if (n == n1) continue;
            return false;
        }
        return true;
    }

    public ArrayList<String> getModVal(MyProperties p) {
        return this.getModVal(p, null);
    }

    public ArrayList<String> getModVal(MyProperties p, String exceptKey) {
        ArrayList<String> a = new ArrayList<String>();
        if (p == null) {
            return a;
        }
        for (String k : this.getKeys()) {
            if (k.equals(" ") || k.equals("#") || k.equals(exceptKey) || k.equals("TIMESTAMP")) continue;
            String v = this.get(k);
            String v1 = p.get(k);
            if (v1 == null || v1 == v) continue;
            if (v1.indexOf(9) < 0 && v.indexOf(9) < 0) {
                if (v1.equals(v)) continue;
                a.add(k + " = " + v + " => " + v1);
                continue;
            }
            if (v1.equals(v)) continue;
            int n = 0;
            int n1 = 0;
            Tok tok = new Tok(v, "\t");
            HashMap<String, String> hash = new HashMap<String, String>(100);
            while (tok.hasMoreTokens()) {
                hash.put(tok.nextToken(), "");
                ++n;
            }
            tok = new Tok(v1, "\t");
            while (tok.hasMoreTokens()) {
                if (hash.get(tok.nextToken()) == null) {
                    n = -1;
                    break;
                }
                ++n1;
            }
            if (n == n1) continue;
            v = v.replace("\t", ", ");
            v1 = v1.replace("\t", ", ");
            a.add(k + " = " + v + " => " + v1);
        }
        return a;
    }

    public ArrayList<String> getDelKey(MyProperties p) {
        ArrayList<String> a = new ArrayList<String>();
        for (String k : this.getKeys()) {
            if (k.equals(" ") || k.equals("#")) continue;
            if (p == null) {
                a.add(k);
                continue;
            }
            String v1 = p.get(k);
            if (v1 != null) continue;
            a.add(k);
        }
        return a;
    }

    public ArrayList<String> getAddKey(MyProperties p) {
        ArrayList<String> a = new ArrayList<String>();
        if (p == null) {
            return a;
        }
        for (String k1 : p.getKeys()) {
            String v;
            if (k1.equals(" ") || k1.equals("#") || (v = this.get(k1)) != null) continue;
            a.add(k1);
        }
        return a;
    }

    private PropItem getItem(String key) {
        return this.hash.get(key);
    }

    public int size() {
        return this.prop.size();
    }

    public long getMem() {
        long mem = 0L;
        for (PropItem item : this.prop) {
            mem += item.getMem();
        }
        return mem;
    }

    public String getProperty(String key, String defaut) {
        String s = this.get(key);
        return s == null ? defaut : s;
    }

    public String getProperty(String key) {
        return this.get(key);
    }

    public String get(String key) {
        PropItem item = this.getItem(key);
        if (item != null) {
            return item.value;
        }
        return null;
    }

    public String getFirst(String key) {
        PropItem item = this.getItem(key);
        if (item == null) {
            return null;
        }
        int i = item.value.indexOf(9);
        if (i >= 0) {
            return item.value.substring(0, i);
        }
        return item.value;
    }

    public Iterator<String> getIteratorValues(String key) {
        final String value = this.get(key);
        if (value == null) {
            return null;
        }
        return new Iterator<String>(){
            int opos = -1;
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos != -1;
            }

            @Override
            public String next() {
                this.pos = value.indexOf(9, this.opos + 1);
                String rep = this.pos == -1 ? value.substring(this.opos + 1) : value.substring(this.opos + 1, this.pos);
                this.opos = this.pos;
                return rep;
            }

            @Override
            public void remove() {
            }
        };
    }

    public void add(String key, String value) {
        this.remove(key);
        PropItem item = new PropItem(key, value);
        this.prop.add(item);
        this.hash.put(key, item);
    }

    public void insert(String key, String value) {
        this.remove(key);
        PropItem item = new PropItem(key, value);
        this.prop.add(0, item);
        this.hash.put(key, item);
    }

    public void remove(String key) {
        this.prop.remove(this.getItem(key));
        this.hash.remove(key);
    }

    public void setProperty(String key, String value) {
        this.replaceValue(key, value);
    }

    public void replaceValue(String key, String value) {
        if (value == null) {
            this.remove(key);
            return;
        }
        PropItem item = this.getItem(key);
        if (item == null) {
            item = new PropItem(key, value);
            this.prop.add(item);
            this.hash.put(key, item);
        } else {
            item.value = value;
        }
    }

    public void put(String key, String value) {
        PropItem item = this.getItem(key);
        if (item == null) {
            item = new PropItem(key, value);
            this.prop.add(item);
            this.hash.put(key, item);
        } else {
            item.value = item.value + "\t" + value;
        }
    }

    public void replaceKey(String oldKey, String key) {
        for (PropItem item : this.prop) {
            if (!item.key.equals(oldKey)) continue;
            item.key = key;
            this.hash.remove(oldKey);
            this.hash.put(key, item);
            return;
        }
    }

    public String getPropOriginal() {
        return this.propOriginal != null ? this.propOriginal.toString() : null;
    }

    private String readLine(InputStreamReader in) throws IOException {
        StringBuilder s = new StringBuilder(256);
        boolean eof = false;
        while (true) {
            int ch;
            if ((ch = in.read()) == -1) {
                eof = true;
                break;
            }
            if (ch == 10) break;
            if (ch == 13) continue;
            s.append((char)ch);
        }
        if (eof && s.length() == 0) {
            return null;
        }
        return s.toString();
    }

    public boolean loadRecord(InputStreamReader in) throws IOException {
        return this.load(in, false, true);
    }

    public void load(InputStreamReader in) throws IOException {
        this.load(in, false, false);
    }

    public synchronized boolean load(InputStreamReader in, boolean flagKeepOriginal, boolean flagBlankLinestop) throws IOException {
        String s;
        if (flagKeepOriginal) {
            this.propOriginal = new StringBuilder();
        }
        this.prop = new ArrayList();
        this.hash = new HashMap();
        while ((s = this.readLine(in)) != null) {
            if (flagKeepOriginal) {
                this.propOriginal.append(s + "\n");
            }
            if (s.trim().length() == 0) {
                if (flagBlankLinestop) {
                    if (this.prop.size() > 0) break;
                    if (this.prop.size() == 0) continue;
                }
                this.prop.add(new PropItem(" ", null));
                continue;
            }
            if (s.charAt(0) == '#') {
                boolean simpleComment = true;
                int egal = s.indexOf(61);
                if (egal > 1) {
                    int blanc = s.indexOf(32);
                    if (blanc < 0) {
                        blanc = s.indexOf(9);
                    }
                    if (blanc > 0 && blanc < egal) {
                        while (Character.isSpace(s.charAt(blanc)) && blanc < egal) {
                            ++blanc;
                        }
                        simpleComment = blanc != egal;
                    } else {
                        simpleComment = false;
                    }
                }
                if (simpleComment) {
                    this.prop.add(new PropItem("#", s));
                    continue;
                }
            }
            if (s.indexOf(61) < 0) continue;
            this.add(s);
        }
        return s != null;
    }

    public void add(String s) {
        String value;
        String key;
        try {
            int offset = s.indexOf(61);
            key = s.substring(0, offset).trim();
            value = s.substring(offset + 1, s.length()).trim();
            if (value.indexOf("\\:") >= 0) {
                char[] a = value.toCharArray();
                char[] b = new char[a.length];
                int j = 0;
                boolean backSlash = false;
                for (int i = 0; i < a.length; ++i) {
                    if (!backSlash && a[i] == '\\') {
                        backSlash = true;
                        continue;
                    }
                    backSlash = false;
                    b[j++] = a[i];
                }
                value = new String(b, 0, j);
            }
        }
        catch (Exception e) {
            System.err.println("MyProperties reader error => " + e.getMessage() + "\n => " + s);
            this.prop.add(new PropItem("#", "#Error: " + s));
            return;
        }
        this.put(key, value);
    }

    public void exceptions(MyProperties except, String id) {
        String value;
        String key;
        for (PropItem item : except.prop) {
            String v;
            if (item.key.startsWith("#") || item.key.startsWith(">")) continue;
            key = item.key;
            value = item.value;
            boolean test = false;
            char c = '\u0000';
            if (item.value.startsWith("!")) {
                value = item.value.substring(1);
                test = true;
            } else if (item.value.startsWith(">")) {
                value = item.value.substring(1);
                c = '>';
            } else if (item.value.startsWith("<")) {
                value = item.value.substring(1);
                c = '<';
            }
            String string = v = key.equals("ID") ? id : this.get(key);
            if (v == null) {
                return;
            }
            if (c != '\u0000') {
                boolean strict = true;
                if (value.startsWith("=")) {
                    strict = false;
                    value = value.substring(1);
                }
                if (MyProperties.testInequality(c, strict, value, v)) continue;
                return;
            }
            if (MyProperties.matchMask(value, v) != test) continue;
            return;
        }
        for (PropItem item : except.prop) {
            PropItem itemProp;
            if (item.key.startsWith("#") || !item.key.startsWith(">")) continue;
            key = item.key.trim().substring(1);
            value = item.value.trim();
            int mode = 0;
            if (item.value.startsWith("+")) {
                value = value.substring(1);
                mode = 1;
            }
            if (item.value.startsWith("-")) {
                value = value.substring(1);
                mode = -1;
            }
            if ((itemProp = this.getItem(key)) == null) {
                if (value.length() <= 0 || mode != 1 && mode != 0) continue;
                this.put(key, value);
                continue;
            }
            if (mode == 0) {
                if (value.length() == 0) {
                    this.remove(key);
                    continue;
                }
                itemProp.value = value;
                continue;
            }
            boolean trouve = false;
            Tok tok = new Tok(itemProp.value, "\t");
            StringBuilder v1 = new StringBuilder();
            while (tok.hasMoreTokens()) {
                String v = tok.nextToken();
                if (mode == -1 && (trouve |= v.equals(value))) continue;
                if (v1.length() > 0) {
                    v1.append("\t");
                }
                v1.append(v);
            }
            if (mode == 1 && !trouve) {
                v1.append("\t" + value);
            }
            itemProp.value = v1.toString();
            if (itemProp.value.length() != 0) continue;
            this.remove(key);
        }
    }

    public void store(OutputStreamWriter out, String comments) throws IOException {
        BufferedWriter bw = new BufferedWriter(out);
        for (PropItem item : this.prop) {
            bw.write(item.toString());
            bw.newLine();
        }
        bw.flush();
    }

    public String toString() {
        StringBuilder s = new StringBuilder(2048);
        for (PropItem item : this.prop) {
            s.append(item.toString());
            s.append('\n');
        }
        return s.toString();
    }

    public String getRecordGlu() {
        return this.getRecordGlu1(true);
    }

    public String getRecordGluX() {
        return this.getRecordGlu1(false);
    }

    private String getRecordGlu1(boolean flagMirror) {
        int i;
        StringBuilder s = new StringBuilder();
        String s1 = this.get("ID");
        int index = s1.indexOf(47);
        String id = s1.substring(index + 1);
        String gluId = id.replace('/', '-');
        String origin = s1.substring(0, index);
        s.append(MyProperties.align("%ActionName", 20) + " " + gluId + ".hpx\n");
        s1 = this.get("obs_title");
        if (s1 == null) {
            s1 = this.get("obs_collection");
        }
        if (s1 == null) {
            s1 = "-- missing description --";
        }
        s.append(MyProperties.align("%Description", 20) + " " + s1 + "\n");
        s.append(MyProperties.align("%Owner", 20) + " aladin\n");
        s.append(MyProperties.align("%DistribDomain", 20) + " ALADIN\n");
        String s2 = this.get("client_application");
        boolean flagLite = s2 != null && s2.indexOf("AladinLite") >= 0;
        int n = 1;
        if (flagMirror || !flagMirror && flagLite) {
            while (this.get("hips_service_url_" + n) != null) {
                ++n;
            }
        }
        if (n == 1) {
            s1 = this.get("hips_service_url");
            if (s1 != null) {
                s.append(MyProperties.align("%Url", 20) + " " + s1 + "\n");
            }
        } else {
            for (i = 0; i < n; ++i) {
                s1 = this.get("hips_service_url" + (i == 0 ? "" : "_" + i));
                s2 = this.get("hips_status" + (i == 0 ? "" : "_" + i));
                if (s2 != null && s2.indexOf("partial") > 0) {
                    s.append("#");
                }
                if (s1 == null) continue;
                s.append(MyProperties.align("%SeeAction", 20) + " " + gluId + "_" + i + ".hpx\n");
            }
        }
        if ((s1 = this.get("obs_description")) != null) {
            s.append(MyProperties.align("%VerboseDescr", 20) + " " + s1 + "\n");
        }
        if (origin.length() > 0) {
            s.append(MyProperties.align("%Origin", 20) + " " + origin + "\n");
        }
        s.append(MyProperties.align("%Id", 20) + " " + id + "\n");
        s1 = this.get("client_application");
        s1 = s1 != null ? (s1.indexOf("AladinDesktopBeta") >= 0 ? " beta" : "") : "";
        s.append(MyProperties.align("%Aladin.Profile", 20) + " >6.1" + s1 + "\n");
        s1 = this.get("obs_copyright");
        if (s1 == null) {
            s1 = this.get("prov_progenitor");
        }
        if (s1 != null) {
            s.append(MyProperties.align("%Copyright", 20) + " " + s1 + "\n");
        }
        if ((s1 = this.get("obs_copyright_url")) != null) {
            s.append(MyProperties.align("%Copyright.Url", 20) + " " + s1 + "\n");
        }
        if ((s1 = this.get("moc_sky_fraction")) != null) {
            s.append(MyProperties.align("%SkyFraction", 20) + " " + s1 + "\n");
        }
        if ((s1 = this.get("obs_collection")) == null) {
            s1 = id;
        }
        s.append(MyProperties.align("%Aladin.XLabel", 20) + " " + s1 + "\n");
        s1 = this.get("client_category");
        if (s1 != null) {
            s.append(MyProperties.align("%Aladin.Tree", 20) + " " + s1 + "\n");
        }
        s1 = this.get("client_sort_key");
        if (flagLite) {
            String string = s1 = s1 != null ? s1 + " lite" : "lite";
        }
        if (s1 != null) {
            s.append(MyProperties.align("%Aladin.MenuNumber", 20) + " " + s1 + "\n");
        }
        if (this.get("hips_service_url") != null) {
            s.append(MyProperties.align("%Aladin.HpxParam", 20));
            s1 = this.get("hips_order");
            if (s1 != null) {
                s.append(" " + s1);
            }
            if ((s1 = this.get("dataproduct_type")) != null) {
                s.append(" " + s1);
            }
            if ((s1 = this.get("dataproduct_subtype")) != null) {
                s.append(" " + s1);
            }
            if ((s1 = this.get("hips_frame")) != null) {
                s.append(" " + s1);
            }
            if ((s1 = this.get("hips_tile_format")) != null) {
                s.append(" " + s1);
            }
            s.append("\n");
        }
        if ((s1 = this.get("hips_release_date")) != null) {
            s.append(MyProperties.align("%Aladin.Date", 20) + " " + s1 + "\n");
        }
        if (n > 1) {
            for (i = 0; i < n; ++i) {
                s1 = this.get("hips_service_url" + (i == 0 ? "" : "_" + i));
                if (s1 == null) continue;
                s.append("\n");
                s.append(MyProperties.align("%ActionName", 20) + " " + gluId + "_" + i + ".hpx\n");
                s.append(MyProperties.align("%Owner", 20) + " CDS'aladin\n");
                s.append(MyProperties.align("%DistribDomain", 20) + " ALADIN\n");
                s.append(MyProperties.align("%Url", 20) + " " + s1 + "\n");
            }
        }
        return s.toString();
    }

    public String getFirstUrl(HashSet<String> fields) {
        StringBuilder s = new StringBuilder();
        for (PropItem item : this.prop) {
            if (!this.isMappingField(item.key, fields)) continue;
            if (item.key.equals("#")) {
                s.append(item.value + "\n");
                continue;
            }
            if (item.key.trim().length() <= 0) continue;
            int pos = -1;
            if ((pos = item.value.indexOf(9, pos + 1)) == -1) {
                pos = item.value.length();
            }
            return item.value.substring(0, pos);
        }
        return null;
    }

    public String getRecord(HashSet<String> fields) {
        return this.getRecord(fields, false);
    }

    public String getRecord(HashSet<String> fields, boolean flagCompact) {
        StringBuilder s = new StringBuilder();
        for (PropItem item : this.prop) {
            if (!this.isMappingField(item.key, fields)) continue;
            if (item.key.equals("#")) {
                s.append(item.value + "\n");
                continue;
            }
            if (item.key.trim().length() <= 0) continue;
            int pos = -1;
            do {
                int opos = pos;
                if ((pos = item.value.indexOf(9, pos + 1)) == -1) {
                    pos = item.value.length();
                }
                s.append(MyProperties.getAsciiLine(item.key, item.value.substring(opos + 1, pos), flagCompact));
            } while (pos < item.value.length());
        }
        return s.toString();
    }

    public static String getAsciiLine(String key, String value, boolean flagCompact) {
        return flagCompact ? key + "=" + value + "\n" : MyProperties.align(key, 20) + " = " + value + "\n";
    }

    public String getRecordHTML(HashSet<String> fields) {
        StringBuilder s = new StringBuilder();
        s.append("<PRE>\n");
        for (PropItem item : this.prop) {
            if (!this.isMappingField(item.key, fields)) continue;
            if (item.key.equals("#")) {
                s.append(item.value + "\n");
                continue;
            }
            if (item.key.trim().length() <= 0) continue;
            int pos = -1;
            do {
                String k;
                String v;
                int opos = pos;
                if ((pos = item.value.indexOf(9, pos + 1)) == -1) {
                    pos = item.value.length();
                }
                if ((v = item.value.substring(opos + 1, pos)).startsWith("http://") || v.startsWith("https://")) {
                    v = "<A HREF=\"" + v + "\" target=\"_top\">" + v + "</A>";
                }
                String c = (k = item.key).startsWith("hips_") ? "grey" : (k.startsWith("obs_") ? "blue" : (k.startsWith("data") ? "magenta" : (k.startsWith("moc_") ? "green" : (k.startsWith("client") ? "orange" : "black"))));
                if (k.equals("ID")) {
                    c = "red";
                    v = "<font size=\"+1\" color=\"" + c + "\"><b>" + v + "</b></font>";
                }
                s.append("<font color=\"" + c + "\"><b>" + MyProperties.align(k, 20) + "</b></font> = " + v + "\n");
            } while (pos < item.value.length());
        }
        s.append("</PRE>\n");
        return s.toString();
    }

    private boolean isMappingField(String key, HashSet<String> fields) {
        if (fields == null) {
            return true;
        }
        boolean deuxTours = false;
        boolean trouve = false;
        boolean onlyRemove = true;
        for (String mask : fields) {
            if (mask.charAt(0) == '!') {
                deuxTours = true;
                continue;
            }
            onlyRemove = false;
            if (!MyProperties.matchMask(mask, key)) continue;
            trouve = true;
            break;
        }
        if (onlyRemove) {
            trouve = true;
        }
        if (!trouve || !deuxTours) {
            return trouve;
        }
        for (String mask : fields) {
            if (mask.charAt(0) != '!' || !MyProperties.matchMask(mask = mask.substring(1), key)) continue;
            return false;
        }
        return true;
    }

    public String getRecordJson(HashSet<String> fields) {
        StringBuilder s = new StringBuilder("{");
        for (PropItem item : this.prop) {
            if (!this.isMappingField(item.key, fields) || item.key.trim().length() <= 0) continue;
            s.append(" \"" + item.key + "\":");
            String value = MyProperties.escapeJson(item.value);
            if (item.value.indexOf(9) == -1) {
                s.append("\"" + value + "\",");
                continue;
            }
            int pos = -1;
            s.append("[ ");
            int len = value.length();
            do {
                int opos = pos;
                if ((pos = value.indexOf(9, pos + 1)) == -1) {
                    pos = len;
                }
                if (opos != -1) {
                    s.append(", ");
                }
                s.append("\"" + value.substring(opos + 1, pos) + "\"");
            } while (pos < len);
            s.append("],");
        }
        s.replace(s.length() - 1, s.length(), "}");
        return s.toString();
    }

    public static String getJsonLine(String key, String value) {
        return " \"" + key + "\":\"" + MyProperties.escapeJson(value) + "\"";
    }

    public static String escapeJson(String s) {
        if (s.indexOf(34) < 0 && s.indexOf(92) < 0) {
            return s;
        }
        char[] a = s.toCharArray();
        StringBuilder s1 = new StringBuilder(a.length);
        for (int i = 0; i < a.length; ++i) {
            char ch1;
            char ch = a[i];
            if (ch == '\"') {
                s1.append('\\');
            } else if (ch == '\\' && i < a.length - 1 && (ch1 = a[i + 1]) != 'n' && ch1 != 't') {
                s1.append('\\');
            }
            s1.append(ch);
        }
        return s1.toString();
    }

    public static String align(String key, int n) {
        return MyProperties.align(key, n, "");
    }

    public static String align(String key, int n, String suffixe) {
        int i = key.length();
        if (i >= n) {
            return key + suffixe + " ";
        }
        StringBuffer s = new StringBuffer();
        for (int j = 0; j < n - i; ++j) {
            s.append(' ');
        }
        return key + suffixe + s;
    }

    public static final String getDate(long ms) {
        return sdf.format(new Date(ms));
    }

    public static boolean testInequality(char c, boolean strict, String ref, String value) {
        try {
            if (value.indexOf(84) > 0) {
                if (ref.indexOf(84) < 0) {
                    ref = ref + "T00:00";
                } else if (ref.charAt(ref.length() - 1) == 'Z') {
                    ref = ref.substring(0, ref.length() - 1);
                }
                if (value.charAt(value.length() - 1) == 'Z') {
                    value = value.substring(0, value.length() - 1);
                }
                Date dNum = sdf.parse(ref);
                Date dProp = sdf.parse(value);
                if (c == '<') {
                    return dProp.compareTo(dNum) < 0;
                }
                return dProp.compareTo(dNum) > 0;
            }
            double vNum = Double.parseDouble(ref.trim());
            double vProp = Double.parseDouble(value.trim());
            if (c == '>') {
                return strict ? vProp > vNum : vProp >= vNum;
            }
            return strict ? vProp < vNum : vProp <= vNum;
        }
        catch (Exception e) {
            if (c == '<') {
                return strict ? value.compareTo(ref) < 0 : value.compareTo(ref) <= 0;
            }
            return strict ? value.compareTo(ref) > 0 : value.compareTo(ref) > 0;
        }
    }

    public static final boolean matchMask(String mask, String word) {
        char cm;
        String s;
        if (word == null || mask == null) {
            return false;
        }
        int n = mask.length();
        if (n == 1 && mask.charAt(0) == '*') {
            return true;
        }
        if (mask.indexOf(42) < 0 && mask.indexOf(63) < 0) {
            return word.equals(mask);
        }
        if (n > 2 && mask.charAt(0) == '*' && mask.charAt(n - 1) == '*' && (s = mask.substring(1, n - 1)).indexOf(42) < 0 && s.indexOf(63) < 0) {
            return word.indexOf(s) >= 0;
        }
        if (n > 2 && mask.charAt(0) == '*' && mask.indexOf(42, 1) < 0 && mask.indexOf(63, 1) < 0) {
            return word.endsWith(mask.substring(1));
        }
        if (n > 2 && mask.charAt(n - 1) == '*' && mask.lastIndexOf(42, n - 1) < 0 && mask.lastIndexOf(63, n - 1) < 0) {
            return word.startsWith(mask.substring(0, n - 1));
        }
        String m = mask + '\u0000';
        String a = word + '\u0000';
        int im = 0;
        int ia = 0;
        int ib = -1;
        int ic = -1;
        while ((cm = m.charAt(im)) != '\u0000' || a.charAt(ia) != '\u0000') {
            if (cm == '\\') {
                ++im;
                continue;
            }
            if (cm == '*' && (im == 0 || m.charAt(im - 1) != '\\')) {
                ib = ++im;
                continue;
            }
            char ca = a.charAt(ia);
            if (ib != -1 && ib != im && ca == cm) {
                ic = ia;
            }
            if (cm == ca || cm == '?') {
                if (cm == '\u0000') {
                    if (ib == -1) {
                        return false;
                    }
                } else {
                    ++im;
                }
                if (ca == '\u0000') {
                    return false;
                }
                ++ia;
                continue;
            }
            if (ib != -1) {
                im = ib;
                if (ic != -1) {
                    ia = ic;
                    ic = -1;
                    continue;
                }
                if (m.charAt(ib) == ca && ca != '\\') continue;
                if (ca == '\u0000') {
                    return false;
                }
                ++ia;
                continue;
            }
            return false;
        }
        return true;
    }

    static {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        sdf.setTimeZone(utc);
    }

    private class PropItem {
        protected String key;
        protected String value;

        private PropItem(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            if (this.key == null || this.value == null) {
                return "";
            }
            if (this.key.equals("#")) {
                return this.value;
            }
            if (this.value.indexOf(9) == -1) {
                return MyProperties.align(this.key, 20) + " = " + this.value;
            }
            StringBuilder s = new StringBuilder();
            Tok tok = new Tok(this.value, "\t");
            while (tok.hasMoreTokens()) {
                if (s.length() > 0) {
                    s.append(CR);
                }
                s.append(MyProperties.align(this.key, 20) + " = " + tok.nextToken());
            }
            return s.toString();
        }

        private long getMem() {
            return 2 * (this.key == null ? 0 : this.key.length()) + (this.value == null ? 0 : this.value.length());
        }
    }
}

